/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.canvas.process;

import filenet.vw.api.VWApplicationSpaceDefinition;
import filenet.vw.api.VWException;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.api.VWStepProcessorInfo;
import filenet.vw.api.VWStepProcessorInfoDefinition;
import filenet.vw.api.VWTransferResult;
import filenet.vw.api.VWWorkflowCollectionDefinition;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.api.VWWorkflowSignature;
import filenet.vw.apps.designer.VWDesignerCoreData;
import filenet.vw.apps.designer.VWPrintProgressDialog;
import filenet.vw.apps.designer.VWSolutionHelper;
import filenet.vw.base.VWDebug;
import filenet.vw.idm.toolkit.IVWIDMDialog;
import filenet.vw.idm.toolkit.IVWIDMDocument;
import filenet.vw.idm.toolkit.IVWIDMItem;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.toolkit.design.VWDesignerPreferences;
import filenet.vw.toolkit.design.canvas.process.VWProcessCollectionMenu;
import filenet.vw.toolkit.design.canvas.process.VWProcessMenuItem;
import filenet.vw.toolkit.design.canvas.resources.VWResource;
import filenet.vw.toolkit.design.message.VWDesignerMessagePanel;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.dialog.VWCheckWorkflowNameDialog;
import filenet.vw.toolkit.design.property.event.IVWCoordinationEventListener;
import filenet.vw.toolkit.design.property.event.VWCoordinationEvent;
import filenet.vw.toolkit.design.visio.VWVisioImportWizardDialog;
import filenet.vw.toolkit.utils.VWDataDictionary;
import filenet.vw.toolkit.utils.VWStepUtils;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.event.IVWToolbarActionListener;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Point;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JOptionPane;

public class VWProcessMenuHelper
implements IVWCoordinationEventListener {
    private static final Dimension DIM_ERROR_DIALOG = new Dimension(575, 275);
    private VWDesignerCoreData m_designerCoreData = null;
    private VWWorkflowCollectionDefinition m_processCollectionDef = null;
    private Vector<VWAuthPropertyData> m_authPropertyDataList = null;
    private VWProcessCollectionMenu m_processCollectionMenu = null;
    private boolean m_bIsDirty = false;
    private boolean m_bImportingWorkflows = false;
    private VWPrintProgressDialog m_printProgressDialog = null;
    private VWDesignerMessagePanel m_messagePanel = null;

    public VWProcessMenuHelper(VWDesignerCoreData designerCoreData) {
        this.m_designerCoreData = designerCoreData;
        this.m_processCollectionMenu = new VWProcessCollectionMenu(this);
        this.m_designerCoreData.getCoordinationEventNotifier().addCoordinationEventListener(this);
    }

    public JMenu getProcessCollectionMenu() {
        return this.m_processCollectionMenu;
    }

    public VWWorkflowCollectionDefinition getWorkflowCollectionDefinition() {
        return this.m_processCollectionDef;
    }

    public boolean getIsCollectionDirty() {
        return this.m_bIsDirty;
    }

    public void clearCollectionDirtyFlag() {
        this.m_bIsDirty = false;
    }

    public void setCollectionDirty() {
        this.m_bIsDirty = true;
    }

    public VWApplicationSpaceDefinition getSelectedApplicationSpaceDefinition() {
        VWApplicationSpaceDefinition appSpaceDef = null;
        String appSpaceName = this.m_processCollectionDef.getApplicationSpaceName();
        if (appSpaceName != null && appSpaceName.length() > 0) {
            appSpaceDef = this.m_designerCoreData.getDataDictionary().getApplicationSpace(appSpaceName);
        }
        if (appSpaceDef == null && (appSpaceDef = this.m_designerCoreData.getDataDictionary().getApplicationSpace("DefaultApplication")) != null) {
            this.m_processCollectionDef.setApplicationSpaceName(appSpaceDef.getName());
        }
        return appSpaceDef;
    }

    public boolean getCanSaveToSameFile() {
        if (this.m_processCollectionDef == null) {
            return false;
        }
        switch (this.m_processCollectionDef.getSource()) {
            case 0: 
            case 2: {
                return true;
            }
            case 1: {
                try {
                    VWWorkflowDefinition[] wflDefs = this.m_processCollectionDef.getWorkflows();
                    return wflDefs.length == 1;
                }
                catch (VWException ex) {
                    VWDebug.logException(ex);
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validateProcessCollection(IVWToolbarActionListener tbActionListener, boolean bDisplayMessage) {
        try {
            this.m_designerCoreData.displayWaitCursor();
            if (this.m_messagePanel == null) {
                this.m_messagePanel = new VWDesignerMessagePanel();
            }
            VWAuthPropertyData authPropertyData = new VWAuthPropertyData(this.m_designerCoreData);
            if (tbActionListener != null) {
                authPropertyData.getToolbarActionNotifier().addToolbarActionListener(tbActionListener);
            }
            this.m_messagePanel.init(authPropertyData, 1);
            boolean bl = this.m_messagePanel.validateProcessCollection(this.m_processCollectionDef, bDisplayMessage);
            Object var6_6 = null;
            this.m_designerCoreData.restoreDefaultCursor();
            return bl;
        }
        catch (Exception ex) {
            try {
                VWDebug.logException(ex);
                VWMessageDialog.showOptionDialog(this.m_designerCoreData.getParentFrame(), ex.getLocalizedMessage(), 1);
                Object var6_7 = null;
                this.m_designerCoreData.restoreDefaultCursor();
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                this.m_designerCoreData.restoreDefaultCursor();
                throw throwable;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String transferProcessCollection(IVWToolbarActionListener tbActionListener, boolean bDisplayMessage) {
        IVWIDMDocument idmDocument;
        String vwVersion;
        block15: {
            block14: {
                block13: {
                    block12: {
                        if (this.m_designerCoreData.getSessionInfo().getSession() != null) break block12;
                        String string = null;
                        Object var9_6 = null;
                        this.m_designerCoreData.restoreDefaultCursor();
                        return string;
                    }
                    vwVersion = null;
                    idmDocument = this.m_designerCoreData.getDesignerDocumentHelper().getIDMDocument();
                    if (idmDocument != null && (vwVersion = idmDocument.getVWVersion()) != null && !this.m_designerCoreData.getSessionInfo().getSession().checkWorkflowIdentifier(vwVersion)) {
                        vwVersion = null;
                    }
                    if (vwVersion != null || this.checkWorkflowNames()) break block13;
                    String string = null;
                    Object var9_7 = null;
                    this.m_designerCoreData.restoreDefaultCursor();
                    return string;
                }
                if (!this.m_designerCoreData.getDesignerPreferences().getShouldValidateBeforeTransfer() || this.validateProcessCollection(tbActionListener, false)) break block14;
                String string = null;
                Object var9_8 = null;
                this.m_designerCoreData.restoreDefaultCursor();
                return string;
            }
            if (this.getIsCollectionDirty()) {
                vwVersion = null;
            }
            if (this.m_designerCoreData.getDesignerDocumentHelper().saveToRepository()) break block15;
            String string = null;
            Object var9_9 = null;
            this.m_designerCoreData.restoreDefaultCursor();
            return string;
        }
        try {
            String documentName = null;
            idmDocument = this.m_designerCoreData.getDesignerDocumentHelper().getIDMDocument();
            if (idmDocument != null) {
                documentName = idmDocument.getCanonicalNameWithVer();
            }
            this.m_designerCoreData.displayWaitCursor();
            vwVersion = this.internalTransferProcessCollection(vwVersion, documentName, bDisplayMessage);
            if (vwVersion != null && idmDocument != null && idmDocument.isCheckedOut() && idmDocument.canCheckin()) {
                idmDocument.setVWVersion(vwVersion);
            }
            String packageName = this.m_processCollectionDef.getName();
            this.m_designerCoreData.getCoordinationEventNotifier().sendCoordinationEvent(this, 701, packageName);
            String string = vwVersion;
            Object var9_10 = null;
            this.m_designerCoreData.restoreDefaultCursor();
            return string;
        }
        catch (Exception ex) {
            try {
                VWDebug.logException(ex);
                VWMessageDialog.showOptionDialog(this.m_designerCoreData.getParentFrame(), ex.getLocalizedMessage(), VWResource.s_transferWorkflow, 1);
                Object var9_11 = null;
                this.m_designerCoreData.restoreDefaultCursor();
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                this.m_designerCoreData.restoreDefaultCursor();
                throw throwable;
            }
        }
        return null;
    }

    public void launchMainProcess(IVWToolbarActionListener tbActionListener) {
        try {
            String vwVersion = this.transferProcessCollection(tbActionListener, false);
            if (vwVersion == null) {
                return;
            }
            VWWorkflowDefinition wflDef = this.m_processCollectionDef.getMainWorkflow();
            this.internalLaunchProcess(vwVersion, wflDef);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_designerCoreData.getParentFrame(), ex.getLocalizedMessage(), VWResource.s_launchMainWorkflow, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNewProcess() {
        try {
            try {
                this.m_designerCoreData.displayWaitCursor();
                this.addWorkflowDefinition(null, this.m_designerCoreData.getDesignerPreferences());
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                VWMessageDialog.showOptionDialog(this.m_designerCoreData.getParentFrame(), ex.getLocalizedMessage(), 1);
                Object var3_2 = null;
                this.m_designerCoreData.restoreDefaultCursor();
            }
            Object var3_1 = null;
            this.m_designerCoreData.restoreDefaultCursor();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.m_designerCoreData.restoreDefaultCursor();
            throw throwable;
        }
    }

    public void addLocalProcess() {
        block3: {
            try {
                FileDialog openFileDialog = this.m_designerCoreData.getFileContext().getOpenFileDialog();
                openFileDialog.setFile(VWResource.s_fileOpenFilterNamePepXpdl);
                openFileDialog.setVisible(true);
                String fileToOpen = openFileDialog.getFile();
                if (fileToOpen == null) break block3;
                VWWorkflowCollectionDefinition newWflColDef = VWWorkflowCollectionDefinition.readFromFile(openFileDialog.getDirectory() + fileToOpen);
                VWWorkflowDefinition[] wflDefs = null;
                if (newWflColDef != null && (wflDefs = newWflColDef.getWorkflows()) != null && wflDefs.length > 0) {
                    this.importWorkflows(wflDefs);
                    break block3;
                }
                throw new VWException("vw.apps.designer.NotAPepOrXPDLFile", "The selected file is not a valid PEP or XPDL file.");
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                VWMessageDialog.showOptionDialog(this.m_designerCoreData.getParentFrame(), ex.getLocalizedMessage(), 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void addRepositoryProcess() {
        block15: {
            IVWIDMDocument IDMDoc;
            byte[] fileContents = null;
            InputStream inStream = null;
            IVWIDMItem idmContext = this.m_designerCoreData.getFileContext().getIDMContextItem();
            String[] resources = VWStringUtils.getResourcesFromString(VWResource.s_select_withHK);
            IVWIDMDialog dialog = VWIDMBaseFactory.instance().getBrowseDialog(idmContext, 17, resources[0], null, "WorkflowDefinition");
            dialog.setTitle(VWResource.s_importWorkflowFromDMSTitle);
            dialog.setButtonMnemonic(resources[1]);
            dialog.setButtonTooltip(VWResource.s_select);
            int returnVal = dialog.showDialog(this.m_designerCoreData.getParentFrame());
            if (0 == returnVal && (IDMDoc = (IVWIDMDocument)dialog.getSelectedItem()) != null && (fileContents = IDMDoc.getContents()) != null) {
                inStream = new ByteArrayInputStream(fileContents);
                VWWorkflowCollectionDefinition newWflColDef = VWWorkflowCollectionDefinition.read(inStream);
                fileContents = null;
                inStream.close();
                inStream = null;
                VWWorkflowDefinition[] wflDefs = null;
                if (newWflColDef != null && (wflDefs = newWflColDef.getWorkflows()) != null && wflDefs.length > 0) {
                    this.importWorkflows(wflDefs);
                } else {
                    throw new VWException("vw.apps.designer.NoWorkflowDefinition", "The selected document is not a valid Workflow Definition document.");
                }
            }
            Object var11_11 = null;
            this.m_bImportingWorkflows = false;
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (Exception ex2) {
                // empty catch block
            }
            fileContents = null;
            {
                break block15;
                catch (Exception ex) {
                    VWDebug.logException(ex);
                    VWMessageDialog.showOptionDialog(this.m_designerCoreData.getParentFrame(), ex.getLocalizedMessage(), VWResource.s_FNOpenErrTitle, 1);
                    Object var11_12 = null;
                    this.m_bImportingWorkflows = false;
                    try {
                        if (inStream != null) {
                            inStream.close();
                        }
                    }
                    catch (Exception ex2) {
                        // empty catch block
                    }
                    fileContents = null;
                }
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                this.m_bImportingWorkflows = false;
                try {
                    if (inStream != null) {
                        inStream.close();
                    }
                }
                catch (Exception ex2) {
                    // empty catch block
                }
                fileContents = null;
                throw throwable;
            }
        }
    }

    public boolean addWorkflowDefinition(VWWorkflowDefinition newWflDef, VWDesignerPreferences designerPreferences) {
        try {
            boolean bCreatedNewWorkflow;
            block20: {
                bCreatedNewWorkflow = true;
                if (newWflDef == null) {
                    int nIndex = 1;
                    VWWorkflowDefinition[] wflDefs = this.m_processCollectionDef.getWorkflows();
                    if (wflDefs != null) {
                        nIndex = wflDefs.length + 1;
                    }
                    while (true) {
                        try {
                            String defaultName = VWResource.s_defaultWorkflowDefinitionNameTemplate.toString(Integer.toString(nIndex));
                            newWflDef = new VWWorkflowDefinition();
                            newWflDef.setName(defaultName);
                            this.m_processCollectionDef.addWorkflow(newWflDef);
                            newWflDef.setAuthorTool("Process Designer");
                            if (designerPreferences.getShouldDisplayInheritedInformation()) {
                                newWflDef.deleteField("F_Trackers");
                            }
                            VWMapNode launchStep = newWflDef.getMainMap().getStartStep();
                            launchStep.setLocation(new Point(50, 50));
                            VWStepUtils.setStepType(launchStep, 1);
                            VWDataDictionary dataDictionary = this.m_designerCoreData.getDataDictionary();
                            VWStepProcessorInfoDefinition defaultLaunchStepProcessor = dataDictionary.getDefaultStepProcessor(0);
                            if (defaultLaunchStepProcessor != null) {
                                ((VWStepDefinition)launchStep).setRequestedInterface(defaultLaunchStepProcessor.getName());
                            }
                            break block20;
                        }
                        catch (VWException ex1) {
                            ++nIndex;
                            continue;
                        }
                        break;
                    }
                }
                this.m_processCollectionDef.addWorkflow(newWflDef);
                bCreatedNewWorkflow = false;
            }
            VWAuthPropertyData newAuthPropertyData = this.addDataItemToList(newWflDef);
            this.setCollectionDirty();
            if (!bCreatedNewWorkflow) {
                newAuthPropertyData.addResourcesToConfig(newWflDef);
                this.m_designerCoreData.getCoordinationEventNotifier().sendCoordinationEvent(this, 756, Boolean.TRUE);
            }
            this.m_designerCoreData.getCoordinationEventNotifier().sendCoordinationEvent(this, 705, newWflDef);
            VWSolutionHelper solutionHelper = this.m_designerCoreData.getSolutionHelper();
            if (solutionHelper != null) {
                String baseWorkClassName = newWflDef.getBaseWorkClassName();
                if (VWStringUtils.compare(baseWorkClassName, "CaseWorkObject") != 0 && VWStringUtils.compare(baseWorkClassName, "WorkObjectEx") != 0) {
                    VWMessageDialog.showOptionDialog(this.m_designerCoreData.getParentFrame(), VWResource.s_mustImportBaseWorkClass.toString(baseWorkClassName), 2);
                } else {
                    boolean bUpdateBaseWorkClass = false;
                    switch (VWMessageDialog.showConfirmDialog(this.m_designerCoreData.getParentFrame(), VWResource.s_okToChangeBaseClass)) {
                        case 1: {
                            bUpdateBaseWorkClass = true;
                            break;
                        }
                        case 2: {
                            bUpdateBaseWorkClass = false;
                            break;
                        }
                        case 4: {
                            return false;
                        }
                    }
                    if (newAuthPropertyData != null && bUpdateBaseWorkClass) {
                        VWStepDefinition launchStep;
                        String defaultLaunchStepProcessorName = solutionHelper.getDefaultLaunchStepProcessorName();
                        if (defaultLaunchStepProcessorName != null && defaultLaunchStepProcessorName.length() > 0 && (launchStep = newWflDef.getLaunchStep()) != null) {
                            launchStep.setRequestedInterface(defaultLaunchStepProcessorName);
                        }
                        newAuthPropertyData.updateWorkflowBaseClass("CaseWorkObject");
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_designerCoreData.getParentFrame(), ex.getLocalizedMessage(), 1);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performImportVisioFileAction() {
        try {
            this.m_designerCoreData.displayWaitCursor();
            VWVisioImportWizardDialog dlg = new VWVisioImportWizardDialog(this.m_designerCoreData);
            dlg.show();
            if (dlg.getExitStatus() == 0) {
                boolean bRenameNewWorkflows = dlg.getShouldRenameNewWorkflows();
                VWWorkflowCollectionDefinition newWflCol = dlg.getNewWorkflows();
                this.addImportedWorkflows(newWflCol, bRenameNewWorkflows);
            }
            Object var5_4 = null;
            this.m_designerCoreData.restoreDefaultCursor();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.m_designerCoreData.restoreDefaultCursor();
            throw throwable;
        }
    }

    public boolean validateProcess(VWAuthPropertyData authPropertyData, boolean bDisplayMessage) {
        try {
            if (this.m_messagePanel == null) {
                this.m_messagePanel = new VWDesignerMessagePanel();
                this.m_messagePanel.init(authPropertyData, 1);
            }
            return this.m_messagePanel.validateProcess(authPropertyData, bDisplayMessage);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_designerCoreData.getParentFrame(), ex.getLocalizedMessage(), 1);
            return false;
        }
    }

    public boolean examineReferences(VWAuthPropertyData authPropertyData, boolean bIsInheritanceEnabled) {
        try {
            if (this.m_messagePanel == null) {
                this.m_messagePanel = new VWDesignerMessagePanel();
                this.m_messagePanel.init(authPropertyData, 1);
            }
            VWWorkflowDefinition[] wflDefs = this.m_processCollectionDef.getWorkflows();
            return this.m_messagePanel.examineReferences(wflDefs, bIsInheritanceEnabled);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_designerCoreData.getParentFrame(), ex.getLocalizedMessage(), 1);
            return false;
        }
    }

    public void removeReferences() {
        this.m_designerCoreData = null;
        this.m_processCollectionDef = null;
        this.m_printProgressDialog = null;
        this.m_messagePanel = null;
    }

    public void handleCoordinationEvent(VWCoordinationEvent event) {
        switch (event.getID()) {
            case 700: {
                this.m_processCollectionDef = (VWWorkflowCollectionDefinition)event.getEventParam();
                this.clearCollectionDirtyFlag();
                this.reinitializeDataItemList();
                this.m_processCollectionMenu.reinitialize();
                break;
            }
            case 705: {
                VWWorkflowDefinition wflDef;
                VWProcessMenuItem menuItem;
                this.m_processCollectionMenu.reinitialize();
                if (this.m_bImportingWorkflows || (menuItem = this.m_processCollectionMenu.findProcessMenuItem((wflDef = (VWWorkflowDefinition)event.getEventParam()).getName())) == null) break;
                this.editProcess(menuItem.getAuthPropertyData());
                break;
            }
            case 706: 
            case 707: 
            case 709: {
                this.m_processCollectionMenu.reinitialize();
                break;
            }
            case 716: {
                VWWorkflowDefinition wflDef = (VWWorkflowDefinition)event.getEventParam();
                VWProcessMenuItem menuItem = this.m_processCollectionMenu.findProcessMenuItem(wflDef.getName());
                if (menuItem == null) break;
                this.editProcess(menuItem.getAuthPropertyData());
                break;
            }
        }
    }

    protected VWAuthPropertyData[] getProcessDataItems() {
        if (this.m_authPropertyDataList != null && this.m_authPropertyDataList.size() > 0) {
            Object[] dataItems = new VWAuthPropertyData[this.m_authPropertyDataList.size()];
            this.m_authPropertyDataList.copyInto(dataItems);
            return dataItems;
        }
        return null;
    }

    protected VWDesignerCoreData getDesignerCoreData() {
        return this.m_designerCoreData;
    }

    protected boolean isMainProcessName(String processName) {
        if (this.m_processCollectionDef == null) {
            return false;
        }
        VWWorkflowDefinition mainWflDef = this.m_processCollectionDef.getMainWorkflow();
        if (mainWflDef != null) {
            return VWStringUtils.compare(processName, mainWflDef.getName()) == 0;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void editProcess(VWAuthPropertyData authPropertyData) {
        try {
            try {
                this.m_designerCoreData.displayWaitCursor();
                this.m_designerCoreData.getCoordinationEventNotifier().sendCoordinationEvent(this, 715, authPropertyData);
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                Object var4_3 = null;
                this.m_designerCoreData.restoreDefaultCursor();
            }
            Object var4_2 = null;
            this.m_designerCoreData.restoreDefaultCursor();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.m_designerCoreData.restoreDefaultCursor();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String transferProcess(VWAuthPropertyData authPropertyData, boolean bDisplayMessage) {
        VWWorkflowDefinition wflDef;
        block11: {
            block10: {
                block9: {
                    if (this.m_designerCoreData.getSessionInfo().getSession() != null) break block9;
                    String string = null;
                    Object var10_6 = null;
                    this.m_designerCoreData.restoreDefaultCursor();
                    return string;
                }
                wflDef = authPropertyData.getWorkflowDefinition();
                if (this.checkWorkflowName(wflDef)) break block10;
                String string = null;
                Object var10_7 = null;
                this.m_designerCoreData.restoreDefaultCursor();
                return string;
            }
            if (!this.m_designerCoreData.getDesignerPreferences().getShouldValidateBeforeTransfer() || this.validateProcess(authPropertyData, false)) break block11;
            String string = null;
            Object var10_8 = null;
            this.m_designerCoreData.restoreDefaultCursor();
            return string;
        }
        try {
            IVWIDMDocument idmDocument;
            IVWIDMDocument idmDocument2;
            boolean bIsMainWorkflow = this.m_designerCoreData.getProcessMenuHelper().isMainProcessName(wflDef.getName());
            String documentName = null;
            if (bIsMainWorkflow && (idmDocument2 = this.m_designerCoreData.getDesignerDocumentHelper().getIDMDocument()) != null) {
                documentName = idmDocument2.getCanonicalNameWithVer();
            }
            this.m_designerCoreData.displayWaitCursor();
            VWTransferResult vwTransferResult = this.internalTransferProcess(wflDef, null, documentName, bDisplayMessage);
            String vwVersion = this.evaluateTransferResult(vwTransferResult, wflDef.getName(), bDisplayMessage);
            if (bIsMainWorkflow && vwVersion != null && (idmDocument = this.m_designerCoreData.getDesignerDocumentHelper().getIDMDocument()) != null && idmDocument.isCheckedOut() && idmDocument.canCheckin()) {
                idmDocument.setVWVersion(vwVersion);
            }
            String string = vwVersion;
            Object var10_9 = null;
            this.m_designerCoreData.restoreDefaultCursor();
            return string;
        }
        catch (Exception ex) {
            try {
                VWDebug.logException(ex);
                VWMessageDialog.showOptionDialog(this.m_designerCoreData.getParentFrame(), ex.getLocalizedMessage(), VWResource.s_transferWorkflow, 1);
                Object var10_10 = null;
                this.m_designerCoreData.restoreDefaultCursor();
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                this.m_designerCoreData.restoreDefaultCursor();
                throw throwable;
            }
        }
        return null;
    }

    protected void launchProcess(VWAuthPropertyData authPropertyData) {
        try {
            String vwVersion = this.transferProcess(authPropertyData, false);
            if (vwVersion == null) {
                return;
            }
            VWWorkflowDefinition wflDef = authPropertyData.getWorkflowDefinition();
            this.internalLaunchProcess(vwVersion, wflDef);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_designerCoreData.getParentFrame(), ex.getLocalizedMessage(), VWResource.s_launchWorkflow, 1);
        }
    }

    protected void saveProcessToLocal(String processName) {
        try {
            FileDialog saveFileDialog = this.m_designerCoreData.getFileContext().getSaveFileDialog();
            String savedDir = saveFileDialog.getDirectory();
            String savedFile = saveFileDialog.getFile();
            VWWorkflowDefinition wflDef = this.m_processCollectionDef.getWorkflow(processName);
            if (wflDef != null) {
                String wflName = wflDef.getName();
                if (wflName != null && wflName.length() > 0) {
                    saveFileDialog.setFile(VWResource.s_fileSaveFilterNameTemplatePep.toString(wflName));
                }
                saveFileDialog.setVisible(true);
                if (saveFileDialog.getFile() == null) {
                    saveFileDialog.setDirectory(savedDir);
                    saveFileDialog.setFile(savedFile);
                } else {
                    wflDef.writeToFile(saveFileDialog.getDirectory() + saveFileDialog.getFile());
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void saveProcessToRepository(String processName) {
        block14: {
            byte[] fileContents;
            ByteArrayOutputStream outStream;
            block12: {
                outStream = null;
                fileContents = null;
                VWWorkflowDefinition wflDef = this.m_processCollectionDef.getWorkflow(processName);
                if (wflDef == null) break block12;
                outStream = new ByteArrayOutputStream();
                wflDef.write(outStream);
                fileContents = outStream.toByteArray();
                outStream.close();
                outStream = null;
                IVWIDMItem idmContext = this.m_designerCoreData.getFileContext().getIDMContextItem();
                IVWIDMDialog dialog = VWIDMBaseFactory.instance().getAddDialog(this.m_designerCoreData.getParentFrame(), idmContext, fileContents, "WorkflowDefinition");
                dialog.setTitle(VWIDMBaseFactory.instance().getVWString(22).toString());
                String wflName = wflDef.getName();
                if (wflName != null && wflName.length() > 0) {
                    dialog.setFilename(VWResource.s_fileSaveFilterNameTemplatePep.toString(wflName));
                }
                dialog.showDialog(this.m_designerCoreData.getParentFrame());
            }
            Object var9_9 = null;
            try {
                if (outStream != null) {
                    outStream.close();
                }
            }
            catch (Exception ex2) {
                // empty catch block
            }
            fileContents = null;
            {
                break block14;
                catch (Exception ex) {
                    VWDebug.logException(ex);
                    VWMessageDialog.showOptionDialog(this.m_designerCoreData.getParentFrame(), ex.getLocalizedMessage(), VWResource.s_FNSaveAsErrTitle, 1);
                    Object var9_10 = null;
                    try {
                        if (outStream != null) {
                            outStream.close();
                        }
                    }
                    catch (Exception ex2) {
                        // empty catch block
                    }
                    fileContents = null;
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                try {
                    if (outStream != null) {
                        outStream.close();
                    }
                }
                catch (Exception ex2) {
                    // empty catch block
                }
                fileContents = null;
                throw throwable;
            }
        }
    }

    protected void setMainProcess(String processName) {
        try {
            this.m_processCollectionDef.setMainWorkflowByName(processName);
            this.m_designerCoreData.getCoordinationEventNotifier().sendCoordinationEvent(this, 709, processName);
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
        }
    }

    protected void printProcess(VWAuthPropertyData authPropertyData, boolean bDisplayPrintDialog) {
        try {
            if (this.m_printProgressDialog == null) {
                this.m_printProgressDialog = new VWPrintProgressDialog(authPropertyData.getDesignerCoreData());
            }
            VWWorkflowDefinition[] wflDefs = new VWWorkflowDefinition[]{authPropertyData.getWorkflowDefinition()};
            this.m_printProgressDialog.printWorkflows(null, wflDefs, bDisplayPrintDialog);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_designerCoreData.getParentFrame(), ex.getLocalizedMessage(), 1);
        }
    }

    protected void removeProcess(String processName, boolean bPromptUser) {
        try {
            int confirmResult;
            if (bPromptUser && (confirmResult = JOptionPane.showConfirmDialog(this.m_designerCoreData.getParentFrame(), VWResource.s_okToRemoveWorkflow, VWResource.s_removeWorkflow, 0)) != 0) {
                return;
            }
            VWWorkflowDefinition wflDef = this.m_processCollectionDef.removeWorkflow(processName);
            this.removeDataItemFromList(wflDef.getName());
            this.m_designerCoreData.getCoordinationEventNotifier().sendCoordinationEvent(this, 707, wflDef);
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
        }
    }

    private boolean checkWorkflowNames() {
        try {
            VWWorkflowDefinition[] wflDefs = this.m_processCollectionDef.getWorkflows();
            for (int nIndex = 0; nIndex < wflDefs.length; ++nIndex) {
                if (wflDefs[nIndex] == null || this.checkWorkflowName(wflDefs[nIndex])) continue;
                return false;
            }
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
        }
        return true;
    }

    private boolean checkWorkflowName(VWWorkflowDefinition processDef) {
        boolean bContinue = false;
        VWCheckWorkflowNameDialog checkWorkflowNameDialog = new VWCheckWorkflowNameDialog(this.m_designerCoreData.getSessionInfo(), processDef.getName());
        boolean bFound = checkWorkflowNameDialog.isExist(processDef.getName());
        if (bFound) {
            checkWorkflowNameDialog.setVisible(true);
            if (checkWorkflowNameDialog.getExitStatus() == 0) {
                try {
                    bContinue = true;
                    String newWorkflowName = checkWorkflowNameDialog.getWorkflowName();
                    if (VWStringUtils.compare(processDef.getName(), newWorkflowName) != 0) {
                        processDef.setName(newWorkflowName);
                        this.setCollectionDirty();
                    }
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                }
            }
        } else {
            bContinue = true;
        }
        return bContinue;
    }

    private void addImportedWorkflows(VWWorkflowCollectionDefinition newWflCol, boolean bRenameNewWorkflows) {
        try {
            if (newWflCol != null && newWflCol.getWorkflows() != null && newWflCol.getWorkflows().length > 0) {
                int nIndex;
                String mainWorkflowName = this.m_processCollectionDef.getMainWorkflow().getName();
                if (!this.getIsCollectionDirty() && this.getIsNewCollection()) {
                    VWWorkflowDefinition[] oldWflDefs = this.m_processCollectionDef.getWorkflows();
                    if (oldWflDefs != null) {
                        for (nIndex = 0; nIndex < oldWflDefs.length; ++nIndex) {
                            this.removeProcess(oldWflDefs[nIndex].getName(), false);
                        }
                    }
                    if (newWflCol.getName() != null) {
                        this.m_processCollectionDef.setName(newWflCol.getName());
                    }
                    if (newWflCol.getDescription() != null) {
                        this.m_processCollectionDef.setDescription(newWflCol.getDescription());
                    }
                }
                VWWorkflowDefinition[] newWflDefs = newWflCol.getWorkflows();
                for (nIndex = 0; nIndex < newWflDefs.length; ++nIndex) {
                    String newWflName = newWflDefs[nIndex].getName();
                    if (this.m_processCollectionDef.isExistingWorkflowName(newWflName)) {
                        if (bRenameNewWorkflows) {
                            int nCounter = 1;
                            while (this.m_processCollectionDef.isExistingWorkflowName(newWflName = newWflDefs[nIndex].getName() + nCounter++)) {
                            }
                            newWflDefs[nIndex].setName(newWflName);
                        } else {
                            this.m_processCollectionDef.removeWorkflow(newWflName);
                        }
                    }
                    this.m_processCollectionDef.addWorkflow(newWflDefs[nIndex]);
                    this.addDataItemToList(newWflDefs[nIndex]);
                    this.m_designerCoreData.getCoordinationEventNotifier().sendCoordinationEvent(this, 705, newWflDefs[nIndex]);
                }
                if (this.m_processCollectionDef.isExistingWorkflowName(mainWorkflowName)) {
                    this.m_processCollectionDef.setMainWorkflowByName(mainWorkflowName);
                }
                this.setCollectionDirty();
            }
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
        }
    }

    private String internalTransferProcessCollection(String vwVersion, String documentName, boolean bDisplayMessage) {
        try {
            if (this.m_designerCoreData.getSessionInfo().getSession() == null) {
                return null;
            }
            VWWorkflowDefinition mainWorkflowDef = this.m_processCollectionDef.getMainWorkflow();
            String processName = mainWorkflowDef.getName();
            if (documentName == null) {
                documentName = processName;
            }
            VWTransferResult vwTransferResult = null;
            if (this.m_designerCoreData.getDesignerDocumentHelper().getCanSaveAsPep()) {
                vwTransferResult = this.internalTransferProcess(mainWorkflowDef, vwVersion, documentName, bDisplayMessage);
                if (vwVersion != null && vwTransferResult == null) {
                    return vwVersion;
                }
            } else {
                boolean bTransferNeeded = true;
                if (vwVersion != null) {
                    boolean bFoundInvalidSignature = false;
                    VWWorkflowDefinition[] wflDefs = this.m_processCollectionDef.getWorkflows();
                    for (int i = 0; i < wflDefs.length; ++i) {
                        if (this.validWorkflowSignature(wflDefs[i])) continue;
                        bFoundInvalidSignature = true;
                        break;
                    }
                    bTransferNeeded = bFoundInvalidSignature;
                }
                if (bTransferNeeded) {
                    vwTransferResult = this.m_designerCoreData.getSessionInfo().getSession().transferWFCollection(this.m_processCollectionDef, documentName, false, false);
                } else {
                    if (bDisplayMessage) {
                        VWMessageDialog.showOptionDialog(this.m_designerCoreData.getParentFrame(), VWResource.s_workflowCollectionAlreadyTransferred, VWResource.s_transferWorkflowCollection, 2);
                    }
                    return vwVersion;
                }
            }
            return this.evaluateTransferResult(vwTransferResult, processName, bDisplayMessage);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_designerCoreData.getParentFrame(), ex.getLocalizedMessage(), VWResource.s_transferWorkflow, 1);
            return null;
        }
    }

    private VWTransferResult internalTransferProcess(VWWorkflowDefinition wflDef, String vwVersion, String documentName, boolean bDisplayMessage) throws Exception {
        if (documentName == null) {
            documentName = wflDef.getName();
        }
        if (vwVersion != null && this.validWorkflowSignature(wflDef)) {
            if (bDisplayMessage) {
                VWMessageDialog.showOptionDialog(this.m_designerCoreData.getParentFrame(), VWResource.s_workflowAlreadyTransferred, VWResource.s_transferWorkflow, 2);
            }
            return null;
        }
        return this.m_designerCoreData.getSessionInfo().getSession().transfer(wflDef, documentName, false, false);
    }

    private boolean validWorkflowSignature(VWWorkflowDefinition wflDef) {
        boolean bTransferWfl = true;
        try {
            String workClassName = wflDef.getName();
            String baseWorkClassName = wflDef.getBaseWorkClassName();
            if (workClassName != null && baseWorkClassName != null) {
                VWSession vwSession = this.m_designerCoreData.getSessionInfo().getSession();
                VWWorkflowSignature wflSignature = vwSession.fetchWorkflowSignature(workClassName);
                VWWorkflowSignature baseWflSignature = vwSession.fetchWorkflowSignature(baseWorkClassName);
                if (wflSignature != null && baseWflSignature != null) {
                    bTransferWfl = wflSignature.getTransferDateTime().getTime() < baseWflSignature.getTransferDateTime().getTime();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return !bTransferWfl;
    }

    private String evaluateTransferResult(VWTransferResult vwTransferResult, String processName, boolean bDisplayMessage) {
        if (vwTransferResult == null) {
            return null;
        }
        if (!vwTransferResult.success()) {
            String[] errors = vwTransferResult.getErrors();
            if (errors != null) {
                if (errors.length == 1) {
                    VWMessageDialog.showOptionDialog(this.m_designerCoreData.getParentFrame(), errors[0], VWResource.s_transferWorkflowCollection, 1);
                } else if (errors.length > 1) {
                    VWMessageDialog.showOptionDialog(this.m_designerCoreData.getParentFrame(), errors, VWResource.s_transferWorkflow, 1, 16, null, VWProcessMenuHelper.DIM_ERROR_DIALOG.width, VWProcessMenuHelper.DIM_ERROR_DIALOG.height);
                }
            }
            return null;
        }
        this.m_designerCoreData.getCoordinationEventNotifier().sendCoordinationEvent(this, 708, processName);
        if (bDisplayMessage) {
            VWMessageDialog.showOptionDialog(this.m_designerCoreData.getParentFrame(), VWResource.s_transferSuccessful, VWResource.s_transferWorkflow, 2);
        }
        return vwTransferResult.getVersion();
    }

    private void internalLaunchProcess(String vwVersion, VWWorkflowDefinition wflDef) throws Exception {
        try {
            block9: {
                VWStepDefinition launchStep;
                block8: {
                    this.m_designerCoreData.displayWaitCursor();
                    launchStep = null;
                    try {
                        VWMapDefinition vwMapDef = wflDef.getMainMap();
                        if (vwMapDef != null) {
                            launchStep = (VWStepDefinition)vwMapDef.getStartStep();
                        }
                    }
                    catch (Exception ex1) {
                        VWMapDefinition vwMapDef;
                        VWWorkflowDefinition vwBaseWflDef = this.m_designerCoreData.fetchBaseWorkflowDefinition(wflDef);
                        if (vwBaseWflDef == null || (vwMapDef = vwBaseWflDef.getMainMap()) == null) break block8;
                        launchStep = (VWStepDefinition)vwMapDef.getStartStep();
                    }
                }
                if (launchStep == null) break block9;
                String processorId = launchStep.getRequestedInterface();
                VWStepProcessorInfo launchStepProcessor = this.m_designerCoreData.getSessionInfo().getSession().fetchStepProcessorInfo(processorId);
                String mainAttachmentDocId = this.m_designerCoreData.getSessionInfo().getProperty("mainAttachmentDocID");
                if (mainAttachmentDocId == null) {
                    mainAttachmentDocId = "";
                }
                this.m_designerCoreData.getOpenItem().openLaunchStepProcessor(launchStepProcessor, vwVersion, "", mainAttachmentDocId);
            }
            Object var8_9 = null;
            this.m_designerCoreData.restoreDefaultCursor();
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.m_designerCoreData.restoreDefaultCursor();
            throw throwable;
        }
    }

    private boolean getIsNewCollection() {
        switch (this.m_processCollectionDef.getSource()) {
            case 0: {
                return true;
            }
            case 1: 
            case 2: {
                return false;
            }
        }
        return false;
    }

    private void reinitializeDataItemList() {
        try {
            VWWorkflowDefinition[] wflDefs;
            this.m_authPropertyDataList = new Vector();
            if (this.m_processCollectionDef != null && (wflDefs = this.m_processCollectionDef.getWorkflows()) != null) {
                for (int nIndex = 0; nIndex < wflDefs.length; ++nIndex) {
                    this.addDataItemToList(wflDefs[nIndex]);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private VWAuthPropertyData addDataItemToList(VWWorkflowDefinition wflDef) {
        VWAuthPropertyData authPropertyData = new VWAuthPropertyData(this.m_designerCoreData);
        authPropertyData.setWorkflowDefinitions(wflDef, null);
        this.m_authPropertyDataList.addElement(authPropertyData);
        return authPropertyData;
    }

    private void removeDataItemFromList(String processName) {
        try {
            if (this.m_authPropertyDataList != null) {
                for (int nIndex = this.m_authPropertyDataList.size() - 1; nIndex >= 0; --nIndex) {
                    VWAuthPropertyData dataItem = this.m_authPropertyDataList.elementAt(nIndex);
                    if (dataItem == null || VWStringUtils.compare(processName, dataItem.getWorkflowDefinition().getName()) != 0) continue;
                    this.m_authPropertyDataList.removeElementAt(nIndex);
                    return;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importWorkflows(VWWorkflowDefinition[] wflDefs) {
        try {
            int nCount;
            ArrayList<String> importedWflDefNames = new ArrayList<String>();
            this.m_bImportingWorkflows = true;
            for (nCount = 0; nCount < wflDefs.length; ++nCount) {
                if (!this.addWorkflowDefinition(wflDefs[nCount], this.m_designerCoreData.getDesignerPreferences())) continue;
                importedWflDefNames.add(wflDefs[nCount].getName());
            }
            this.m_bImportingWorkflows = false;
            for (nCount = 0; nCount < importedWflDefNames.size(); ++nCount) {
                VWProcessMenuItem menuItem = this.m_processCollectionMenu.findProcessMenuItem((String)importedWflDefNames.get(nCount));
                if (menuItem == null) continue;
                this.editProcess(menuItem.getAuthPropertyData());
            }
            Object var6_5 = null;
            this.m_bImportingWorkflows = false;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.m_bImportingWorkflows = false;
            throw throwable;
        }
    }
}

